/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.model;

import com.aptana.core.util.ObjectUtil;
import com.aptana.css.core.model.BaseElement;
import com.aptana.css.core.model.SpecificationElement;
import com.aptana.index.core.IndexUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PseudoElementElement
extends BaseElement {
    private static final String SPECIFICATIONS_PROPERTY = "specifications";
    private static final String ALLOW_PSEUDO_CLASS_SYNTAX_PROPERTY = "allowPseudoClassSyntax";
    private boolean _allowPseudoClassSyntax;
    private List<SpecificationElement> _specifications;

    public void addSpecification(SpecificationElement specification) {
        if (specification != null) {
            if (this._specifications == null) {
                this._specifications = new ArrayList<SpecificationElement>();
            }
            this._specifications.add(specification);
        }
    }

    public boolean allowPseudoClassSyntax() {
        return this._allowPseudoClassSyntax;
    }

    @Override
    public void fromJSON(Map object) {
        super.fromJSON(object);
        this.setAllowPseudoClassSyntax(Boolean.TRUE == object.get(ALLOW_PSEUDO_CLASS_SYNTAX_PROPERTY));
        this._specifications = IndexUtil.createList(object.get(SPECIFICATIONS_PROPERTY), SpecificationElement.class);
    }

    public List<SpecificationElement> getSpecifications() {
        return this._specifications;
    }

    public void setAllowPseudoClassSyntax(Boolean allow) {
        this._allowPseudoClassSyntax = allow;
    }

    @Override
    public void toJSON(JSON.Output out) {
        super.toJSON(out);
        out.add(ALLOW_PSEUDO_CLASS_SYNTAX_PROPERTY, this.allowPseudoClassSyntax());
        out.add(SPECIFICATIONS_PROPERTY, this.getSpecifications());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PseudoElementElement)) {
            return false;
        }
        PseudoElementElement other = (PseudoElementElement)obj;
        return ObjectUtil.areEqual((Object)this.getName(), (Object)other.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

